<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis datového soboru zaměření</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis datového soboru zaměření</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="SurveyFieldbook">
                                <table class="margin" cellpadding="2" width="80%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Jednotky:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@surveyLinearUnits"/></td>
                                        </tr>                                        
                                    </tbody>
                                </table>
                                <hr />
                                <!-- Cogo Point Data -->
                                <xsl:for-each select="SurveyNetworkList">
                                    <table class="margin" cellpadding="2" cellspacing="1" width="100%">
                                        <colgroup span="2">
                                            <col width="30%"/>
                                            <col width="70%"/>
                                        </colgroup>
                                        <tbody>
                                            <xsl:for-each select="SurveyNetwork">
                                                <tr>
                                                    <th align="right" lang="en">Název:&#xa0; </th>
                                                    <td><xsl:value-of select="@name"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Počet nastavení:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@numberOfSetups"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Počet řídících bodů:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@numberOfControlPoints"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Počet bodů:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@numberOfPoints"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Počet řetězců:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@numberOfChains"/>
                                                    </td>
                                                </tr>                                                
                                                <tr>
                                                    <th align="right" lang="en">Počet měření:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@numberOfObservations"/>
                                                    </td>
                                                </tr>                                                
                                                <tr>
                                                    <th align="right" lang="en">Název souboru:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@fileName"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Popis:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@description"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Datum/Čas:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@dateTime"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Název uživatele:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@userName"/>
                                                    </td>
                                                </tr>
                                                <tr><td colspan="2">&#xa0;</td></tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
			Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje minimálně jeden datový soubor.</p>
			<p class="normal1">Pro nejlepší výsledek spusťte výpis z panelu Detaily.   Vyberte jeden nebo více datových souborů v Průzkumníku projektu, které jsou v panelu Detaily.  Zvýrazněte řádky, které chcete mít ve výpisu, a pravým tlačítkem zvolte Výpis na vybraných položkách.</p>
            <p class="normal1">Po otevření Průzkumníku výpisů zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
